1. INTRODUCTION

Wine est un programme qui permet d'exécuter les logiciels écrits
pour Microsoft Windows (comprenant les exécutables DOS, Windows 3.x,
Win32 et Win64) sur un Unix. Il est composé d'un chargeur qui charge et
exécute un binaire Microsoft Windows, ainsi que d'une bibliothèque (appelée
Winelib) qui implémente les appels de l'API de Windows par leur
équivalent Unix ou X11. Cette bibliothèque peut également être utilisée
pour porter du code Windows vers un exécutable Unix natif.

Wine est un logiciel libre, distribué sous GNU LGPL ; lisez le fichier
LICENSE pour plus de détails.

2. DÉMARRAGE RAPIDE

Quand vous compilez à partir des sources, il est recommandé d'utiliser
l'installeur de Wine pour construire et installer Wine. À partir du
répertoire racine des sources de Wine, exécutez :

./tools/wineinstall

Pour exécuter un programme, tapez « wine [options] programme ». Pour des
informations complémentaires et la résolutions de problèmes, lisez la
suite de ce fichier, les pages de manuel de Wine, et surtout les nombreuses
informations que vous trouverez sur http://www.winehq.org.

3. CONFIGURATION NÉCESSAIRE

Pour compiler et exécuter Wine, vous devez disposer d'un des systèmes
d'exploitation suivants :

	Linux version 2.0.36 ou ultérieur
	FreeBSD 7.0 ou ultérieur
	Solaris x86 9 ou ultérieur
	NetBSD-current
	Mac OS X 10.4 ou ultérieur

Étant donné que Wine nécessite une implémentation des « threads » (processus
légers) au niveau du noyau, seuls les systèmes d'exploitation mentionnés
ci-dessus sont supportés. D'autres systèmes d'exploitation implémentant les
threads noyau peuvent être pris en charge dans le futur.

Informations FreeBSD :
  Wine ne fonctionnera généralement pas bien avec les versions FreeBSD
  antérieures à 7.0.  Voyez http://wiki.freebsd.org/Wine pour plus
  d'informations.

Informations Solaris :
  Il est plus que probable que vous deviez construire Wine avec la chaîne
  d'outils GNU (gcc, gas, etc.). Attention : installer gas n'assure pas
  qu'il sera utilisé par gcc.  Recompiler gcc après l'installation de gas
  ou créer un lien symbolique de cc, as et ld vers les outils GNU correspondants
  semble nécessaire.

Informations NetBSD :
  Assurez-vous que les options USER_LDT, SYSVSHM, SYSVSEM et SYSVMSG sont
  activées dans votre noyau.

Informations Mac OS X :
  Xcode 2.4 ou ultérieur est nécessaire pour compiler Wine sous x86.


Systèmes de fichiers pris en charge :
  Wine devrait fonctionner sur la plupart des systèmes de fichiers. Certains
  problèmes de compatibilité ont été rapportés lors de l'utilisation de fichiers
  accédés via Samba. De plus, NTFS ne fournit pas toutes les fonctionnalités de
  système de fichiers nécessaires pour certains applications. L'utilisation d'un
  système de fichiers Linux natif est recommandée.

Configuration de base requise :
  Les fichiers d'en-tête de X11 (appelés xlib6g-dev sous Debian et XFree86-devel
  sous RedHat) doivent être installés.

  Bien entendu, vous aurez besoin du programme « make » (très probablement GNU
  make).

  flex 2.5.33 ou ultérieur, ainsi que bison, sont également requis.

Bibliothèques optionnelles :
  « configure » affiche des messages quand des bibliothèques optionnelles ne
  sont pas détectées sur votre système.
  Consultez http://wiki.winehq.org/Recommended_Packages (en anglais) pour des
  indications sur les paquets logiciels que vous devriez installer.

  Sur les plates-formes 64 bits, si vous compilez Wine pour le mode 32 bits
  (mode par défaut), les versions 32 bits de ces bibliothèques doivent être
  installées. Voyez http://wiki.winehq.org/WineOn64bit pour les détails.
  Si vous désirez un Wine 64 bits pur (ou une configuration mixte 32/64 bits),
  consultez http://wiki.winehq.org/Wine64.

4. COMPILATION

Au cas où vous choisiriez de ne pas utiliser wineinstall, exécutez les commandes
suivantes pour construire Wine :

./configure
make

Cela va construire le programme « wine », ainsi que nombreux binaires et
bibliothèques de support.
Le programme « wine » charge et exécute les exécutables Windows.
La bibliothèque « libwine » (alias « Winelib ») peut être utilisée pour compiler
et lier du code source Windows sous Unix.

Pour voir les options de compilation, tapez « ./configure --help ».

5. INSTALLATION

Une fois Wine construit correctement, « make install » installe l'exécutable
wine, les bibliothèques associées, les pages de manuel de Wine et quelques
autres fichiers nécessaires.

N'oubliez pas de désinstaller toutes les installations précédentes : essayez
« dpkg -r wine », « rpm -e wine » ou « make uninstall » avant d'installer
une nouvelle version.

Une fois l'installation terminée, vous pouvez naviguer dans la section Support
sur http://www.winehq.org/ pour obtenir des astuces de configuration.


6. EXÉCUTER DES PROGRAMMES

Lorsque l'on invoque Wine, vous pouvez spécifier le chemin entier vers
l'exécutable ou seulement le nom de fichier.

Pour exécuter le bloc-notes par exemple :

    wine notepad               (en utilisant le chemin d'accès spécifié
    wine notepad.exe            dans la base de registre pour localiser
                                le fichier)

    wine c:\\windows\\notepad.exe  (en utilisant la syntaxe de fichiers DOS)

    wine ~/.wine/drive_c/windows/notepad.exe  (en utilisant la syntaxe Unix)

    wine notepad.exe lisezmoi.txt
            (en appelant le programme avec des paramètres)

Wine n'est pas parfait, et certains programmes peuvent donc planter. Si
cela se produit, vous obtiendrez un journal du crash que vous devriez
attacher à un éventuel rapport de bogue.


7. INFORMATIONS COMPLÉMENTAIRES

WWW
    Beaucoup d'informations à propos de Wine sont disponibles sur WineHQ
    (http://www.winehq.org) : divers guides, base de données d'applications,
    suivi de bogues. C'est probablement le meilleur point de départ.

FAQ
    La Foire aux Questions de Wine se trouve sur http://www.winehq.org/FAQ

Wiki
    Le wiki Wine est situé sur http://wiki.winehq.org

Listes de diffusion
    Il existe plusieurs listes de diffusion pour les utilisateurs et
    développeurs Wine ; voyez http://www.winehq.org/forums pour de plus
    amples informations.

Bogues
    Rapportez les bogues sur le Bugzilla Wine sur http://bugs.winehq.org
    Merci de vérifier au préalable dans la base de données de bugzilla
    que le problème n'est pas déjà connu, ou a déjà été corrigé.

IRC
    L'aide en ligne est disponible via le canal #WineHQ sur irc.freenode.net.

Git
    L'arbre de développement actuel de Wine est disponible via Git.
    Voyez http://www.winehq.org/git pour plus d'informations.

Si vous ajoutez quelque chose ou corrigez un bogue, merci d'envoyer un correctif
(de préférence en utilisant git-format-patch) à la liste de diffusion
wine-patches@winehq.org pour inclusion dans la version suivante.

--
Alexandre Julliard
julliard@winehq.org
