/******************************************************************************
 * File Name    : NewStudentConnectWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : Initialize and show new student
 ******************************************************************************/
#include <glib/gi18n.h>
#include "NewStudentConnectWindow.h"
#include "ShellControllerWindow.h"
#include "SESCommonDef.h"

using namespace LibSESData;
using namespace IPCAPI;
using namespace std;

namespace ShellController
{

#define NEW_STUDENT_WINDOW_WIDTH 300
#define NEW_STUDENT_WINDOW_HEIGHT 200
#define NEW_STUDENT_WINDOW_BORDER_WIDTH 1
/******************************************************************************
 * Function Name: NewStudentConnectWindow
 * Description  : Constructor
 * Date         : 2008/9/10
 * Parameter    : student		the comming new student
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
NewStudentConnectWindow::NewStudentConnectWindow(tagStudent_t& student)
	: m_isAccept(0)
	, m_isAddToClass(0)
	, m_isKeepSameOP(0)
	, m_student(student)
	, m_pShellControllerWindow(NULL)
	, m_handlerID(0)
{
	CSESLog::WriteLine("NewStudentConnectWindow::NewStudentConnectWindow<<Start");
	m_gWindow = NULL;
	m_gAdd2ClassCheckBtn = NULL;
	m_gKeepSameOPCheckBtn = NULL;
	//m_SystemSettingData = new CSESSystemSettingData();
	CSESLog::WriteLine("NewStudentConnectWindow::NewStudentConnectWindow>>End");
}
/******************************************************************************
 * Function Name: ~NewStudentConnectWindow
 * Description  : Donstructor
 * Date         : 2008/9/10
 * Parameter    :
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
NewStudentConnectWindow::~NewStudentConnectWindow()
{

}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Make NewStudentConnectWindow in modal style
 * Date         : 2008/9/10
 * Parameter    : parentWindow		parent GtkWidget
 * 				  cb				callback function
 * 				  data 				user data
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("NewStudentConnectWindow::ShowModal<<Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));

	m_pShellControllerWindow = (ShellControllerWindow*)data;

	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL!=cb)
	{
		//m_handlerID = g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
		m_handlerID = g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), this);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("NewStudentConnectWindow::ShowModal>>End");
	return 0;
}
/******************************************************************************
 * Function Name: CloseDueToDisconnect
 * Description  :
 * Date         : 2008/11/10
 * Parameter    :
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::CloseDueToDisconnect()
{
	int ret = 0;

	// because this dialog is closed due to student disconnect,
	// so we do not care the return value, disconnect the handler.
	if ( 0 != m_handlerID )
	{
		g_signal_handler_disconnect(G_OBJECT(m_gWindow), m_handlerID);
	}

	gtk_widget_destroy(m_gWindow);

	return ret;
}

/******************************************************************************
 * Function Name: Init
 * Description  : Init NewStudentConnectWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::Init()
{
	CSESLog::WriteLine("NewStudentConnectWindow::Init<<Start");
	GtkWidget* pMainVbox = NULL;
	GtkWidget* pCheckBtnHbox = NULL;
	GtkWidget* pLabelVbox = NULL;
	GtkWidget* pBottomHbox = NULL;
	GtkWidget* pNewStuInfoLabel = NULL;
	GtkWidget* pNewStuNameLabel = NULL;
	GtkWidget* pNewStuIDLabel = NULL;
	GtkWidget* pAskLabel = NULL;
	GtkWidget* pBtn = NULL;
	string studentName("Student Name: ");
	string studentID("Student ID: ");

	string systemSettingsConfigDir("");
	systemSettingsConfigDir.append(LibSESData::CONFIG_FILE_DIR);
	systemSettingsConfigDir.append(LibSESData::SES_SYSTEM_SETTING);
	m_SystemSettingData.LoadFromFile(systemSettingsConfigDir);

	m_gWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (m_gWindow), _("New Students Connect"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("New Students Connect"), "SES");
	gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), NEW_STUDENT_WINDOW_BORDER_WIDTH);
	gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), NEW_STUDENT_WINDOW_WIDTH ,NEW_STUDENT_WINDOW_HEIGHT);
	gtk_window_set_resizable (GTK_WINDOW (m_gWindow), FALSE);
	gtk_window_set_position(GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);

	pMainVbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (m_gWindow), pMainVbox);


	pLabelVbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(pMainVbox), pLabelVbox, FALSE, FALSE, 0);


	GtkWidget* pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pLabelVbox), pHbox, FALSE, FALSE, 10);


	pNewStuInfoLabel = gtk_label_new (_("A new student wants to connect!"));
	gtk_widget_set_tooltip_text (pNewStuInfoLabel, _("A new student wants to connect!"));
	gtk_box_pack_start(GTK_BOX(pHbox), pNewStuInfoLabel, FALSE, FALSE, 10);


	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pLabelVbox), pHbox, FALSE, FALSE, 5);


	studentName = studentName.append(m_student.username);
	pNewStuNameLabel = gtk_label_new (studentName.c_str());
	gtk_misc_set_alignment(GTK_MISC(pNewStuNameLabel), 0, 0.5);
	gtk_label_set_max_width_chars(GTK_LABEL(pNewStuNameLabel), 30);
    //gtk_label_set_justify(GTK_LABEL(pNewStuNameLabel), GTK_JUSTIFY_LEFT);
    gtk_label_set_ellipsize(GTK_LABEL(pNewStuNameLabel), PANGO_ELLIPSIZE_END);
	gtk_widget_set_tooltip_text (pNewStuNameLabel, studentName.c_str());
	gtk_box_pack_start(GTK_BOX(pHbox), pNewStuNameLabel, FALSE, FALSE, 10);


	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pLabelVbox), pHbox, FALSE, FALSE, 5);


	studentID = studentID.append(m_student.studentID);
	pNewStuIDLabel = gtk_label_new (studentID.c_str());
	gtk_misc_set_alignment(GTK_MISC(pNewStuIDLabel), 0, 0.5);
	gtk_label_set_max_width_chars(GTK_LABEL(pNewStuIDLabel), 30);
    //gtk_label_set_justify(GTK_LABEL(pNewStuNameLabel), GTK_JUSTIFY_LEFT);
    gtk_label_set_ellipsize(GTK_LABEL(pNewStuIDLabel), PANGO_ELLIPSIZE_END);
	gtk_widget_set_tooltip_text (pNewStuIDLabel, studentID.c_str());
	gtk_box_pack_start(GTK_BOX(pHbox), pNewStuIDLabel, FALSE, FALSE, 10);


	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pLabelVbox), pHbox, FALSE, FALSE, 5);


	pAskLabel = gtk_label_new (_("Do you allow this connection?"));
	gtk_widget_set_tooltip_text (pAskLabel, _("Do you allow this connection?"));
	gtk_box_pack_start(GTK_BOX(pHbox), pAskLabel, FALSE, FALSE, 10);



	pCheckBtnHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pMainVbox), pCheckBtnHbox, FALSE, FALSE, 5);


	m_gKeepSameOPCheckBtn = gtk_check_button_new_with_label(_("Remember my selection"));
	g_signal_connect (G_OBJECT (m_gKeepSameOPCheckBtn), "toggled", G_CALLBACK (KeepSameOPCallBack), this);
	gtk_box_pack_start (GTK_BOX (pCheckBtnHbox), m_gKeepSameOPCheckBtn, FALSE, FALSE, 5);


//	pCheckBtnHbox = gtk_hbox_new (FALSE, 0);
//	gtk_box_pack_start (GTK_BOX (pMainVbox), pCheckBtnHbox, FALSE, FALSE, 0);
//	gtk_widget_show (pCheckBtnHbox);
//
//	m_gAdd2ClassCheckBtn =  gtk_check_button_new_with_label(_("Add This Student to Current Class For Ever"));
//	gtk_box_pack_start (GTK_BOX (pCheckBtnHbox), m_gAdd2ClassCheckBtn, FALSE, FALSE, 5);
//	gtk_widget_show(m_gAdd2ClassCheckBtn);

	pBottomHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (pMainVbox), pBottomHbox, FALSE, FALSE, 10);


	pBtn = gtk_button_new_with_label (_("Deny"));
	gtk_box_pack_end (GTK_BOX (pBottomHbox), pBtn, FALSE, FALSE, 10);
	g_signal_connect (G_OBJECT (pBtn), "clicked", G_CALLBACK (OnDenyButtonClick), this);
	gtk_widget_set_tooltip_text (pBtn, _("Deny"));
	gtk_widget_set_size_request(pBtn, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);


	pBtn = gtk_button_new_with_label (_("Allow"));
	gtk_box_pack_end (GTK_BOX (pBottomHbox), pBtn, FALSE, FALSE, 0);
	gtk_widget_set_tooltip_text (pBtn, _("Allow"));
	g_signal_connect (G_OBJECT (pBtn), "clicked", G_CALLBACK (OnAcceptButtonClick), this);
	gtk_widget_set_size_request(pBtn, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);


	pBtn = gtk_button_new_with_label (_("Add to class"));
	gtk_box_pack_start (GTK_BOX (pBottomHbox), pBtn, FALSE, FALSE, 10);
	gtk_widget_set_tooltip_text (pBtn, _("Add to class"));
	g_signal_connect (G_OBJECT (pBtn), "clicked", G_CALLBACK (OnSaveButtonClick), this);
	gtk_widget_set_size_request(pBtn, 100, SES_BUTTON_HEIGHT);
	gtk_widget_set_sensitive(pBtn, true);


	CSESLog::WriteLine("NewStudentConnectWindow::Init>>End");
	return 0;
}
/******************************************************************************
 * Function Name: OnAcceptButtonClick
 * Description  : Button accept event
 * Date         : 2008/9/10
 * Parameter    : widget		the GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void NewStudentConnectWindow::OnAcceptButtonClick(GtkWidget* widget, gpointer data)
{
	CSESLog::WriteLine("NewStudentConnectWindow::OnAcceptButtonClick<<Start");
	if (NULL == data || NULL == widget)
	{
		return;
	}

	NewStudentConnectWindow* ptr = (NewStudentConnectWindow*)data ;
	ptr->m_isAccept = TRUE;
	//ptr->m_isDeny = FALSE;

//	ptr->m_isAddToClass = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gAdd2ClassCheckBtn));

	ptr->m_isKeepSameOP = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gKeepSameOPCheckBtn));

	// save user selection.
	if (ptr->m_isKeepSameOP)
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(FALSE);
		ptr->m_SystemSettingData.SetConnectPolicyAllow(TRUE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(FALSE);

	}
	else
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(TRUE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(FALSE);
	}
	ptr->m_SystemSettingData.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::SES_SYSTEM_SETTING);
	gtk_widget_destroy(ptr->m_gWindow);

	CSESLog::WriteLine("NewStudentConnectWindow::OnAcceptButtonClick>>End");
}
/******************************************************************************
 * Function Name: OnDenyButtonClick
 * Description  : Button deny event
 * Date         : 2008/9/10
 * Parameter    : widget		the GtkWidget which triggers the event
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void NewStudentConnectWindow::OnDenyButtonClick(GtkWidget* widget, gpointer data)
{
	CSESLog::WriteLine("NewStudentConnectWindow::OnDenyButtonClick<<Start");

	if (NULL == data || NULL == widget)
	{
		return;
	}

	NewStudentConnectWindow* ptr = (NewStudentConnectWindow*)data ;
	ptr->m_isAccept = FALSE;

//	ptr->m_isAddToClass = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gAdd2ClassCheckBtn));
	ptr->m_isKeepSameOP = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gKeepSameOPCheckBtn));

	// save user selection.
	if (ptr->m_isKeepSameOP)
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(FALSE);
		ptr->m_SystemSettingData.SetConnectPolicyAllow(FALSE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(FALSE);
	}
	else
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(TRUE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(FALSE);
	}
	ptr->m_SystemSettingData.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::SES_SYSTEM_SETTING);
	CSESLog::WriteLine("NewStudentConnectWindow::OnDenyButtonClick>>End");
	gtk_widget_destroy(ptr->m_gWindow);
}

void NewStudentConnectWindow::OnSaveButtonClick(GtkWidget* widget, gpointer data)
{
	NewStudentConnectWindow* ptr = (NewStudentConnectWindow*)data ;
	ptr->m_isKeepSameOP = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gKeepSameOPCheckBtn));

	ptr->m_isAccept = TRUE;
	ptr->m_isAddToClass = TRUE;
	if(ptr->m_isKeepSameOP)
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(FALSE);
		ptr->m_SystemSettingData.SetConnectPolicyAllow(TRUE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(TRUE);
	}
	else
	{
		ptr->m_SystemSettingData.SetNewStudentConnectDialogEnable(TRUE);
		ptr->m_SystemSettingData.SetAddToCurrentClassAllow(TRUE);
	}
	ptr->m_SystemSettingData.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::SES_SYSTEM_SETTING);
	gtk_widget_destroy(ptr->m_gWindow);
}
/******************************************************************************
 * Function Name: IsAccept
 * Description  : Justify whether accept the new student or not
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Accept		1;
 * 				  Deny			0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::IsAccept()
{
	return m_isAccept;
}
/******************************************************************************
 * Function Name: IsDeny
 * Description  : Justify whether deny the new student or not
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Deny				1;
 * 				  Accept			0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::IsDeny()
{
	return !m_isAccept;
}
/******************************************************************************
 * Function Name: IsAddToClass
 * Description  : Justify whether the new student is added to class or not
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK				1;
 * 				  NOT				0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int NewStudentConnectWindow::IsAddToClass()
{
	return m_isAddToClass;
}

void NewStudentConnectWindow::GetResult(int& isAllow, int& addToClass, int& saveToFile)
{
	isAllow 	= m_isAccept;
	addToClass 	= m_isAddToClass;
	saveToFile 	= m_isKeepSameOP;
}


/******************************************************************************
 * Function Name: GetStudent
 * Description  : Get the new student
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : A new students
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
tagStudent_t NewStudentConnectWindow::GetStudent()
{
	return m_student;
}
void NewStudentConnectWindow::KeepSameOPCallBack(GtkToggleButtonClass* toggleBtn, gpointer data)
{
	NewStudentConnectWindow* ptr = (NewStudentConnectWindow*)data ;
	ptr->m_isKeepSameOP = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ptr->m_gKeepSameOPCheckBtn));
}

}
