/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          DialogRegister.h

Description:

    This file defines class DialogRegister.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef DIALOGREGISTER_H_INCLUDED
#define DIALOGREGISTER_H_INCLUDED

#include "PMDialog.h"
#include "BatteryInfoDialog.h"
#include "PMTrayIcon.h"

class PMTrayIcon;
class PMDialog;

class DialogRegister
{
private:
    //constructor
    DialogRegister();
public:
    //destructor
    ~DialogRegister();
    //attach pm dialog
    void SetPtrPMDialog(PMDialog* ptrPMDialog);
    //get pm dialog
    PMDialog* GetPtrPMDialog();
    //attach battery dialog
    void SetPtrBatteryInfoDialog(BatteryInfoDialog* ptrBatteryInfoDialog);
    //get battery dialog
    BatteryInfoDialog* GetPtrBatteryInfoDialog();
    //get sington instance
    static DialogRegister* GetInstance();
    //attach tray icon
    void SetPtrTask(PMTrayIcon* ptrTask);
    //get tray icon
    PMTrayIcon* GetPtrTask();


private:
    PMDialog* ptrPMDialog;
    BatteryInfoDialog* ptrBatteryInfoDialog;
    PMTrayIcon* ptrTask;
    static DialogRegister* ptrDialogRegister;
};

#endif // DIALOGREGISTER_H_INCLUDED
