/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          AboutDialog.h

Description:

    This file defines class AboutDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef DATAMIDDLE_H
#define DATAMIDDLE_H

#include "PowerSchemeMgmtProxy.h"

class PMDialog;
class PMEditDialog;
class OptionsDialog;
class AboutDialog;
//class DeviceDisableDialog;

class DataMiddle
{
public:
    ~DataMiddle(){}
    static DataMiddle* GetInstance();

    // PM dialog related operation
    void AttachPMDialog(PMDialog* pDialog);
    //dettach pm dialog
    void DettachPMDialog();
    //update pm dialog
    void UpdatePMDialog(PScheme_Info scheme_Info);
    //update pm dialog
    void UpdatePMDialogDeviceStatus(int isAC, vector<string> &deviceVector, int schemeId);
//    void UpdatePMDlgEditingScheme(int schemeId);
    //update pm dialog
    void UpdatePMDlgButtonStatusAfterSwitching(int schemeId);
    //update pm dialog
    void UpdatePMDlgSchemeNameList(int schemeId);
    //update pm dialog
    bool IsEditingTheScheme(int schemeId);

    // Edit dialog related operation
    void AttachPMEditDlg(PMEditDialog* pEditDlg);
    //dettach pm edit dialog
    void DettachPMEditDlg();
    //get pm edit dialog
    PMEditDialog* GetPMEditDlgInstance();
    //update pm edit dialog
    void UpdatePMEditDlgDeviceStatus(int isAC, vector<string> &changedDeviceVector, int schemeId);

    // Options dialog related operation
    void AttachOptionsDlg(OptionsDialog* pOptionsDlg);
    //dettach options dialog
    void DettachOptionsDlg();
    //get options dialog
    OptionsDialog* GetOptionsDlgInstance();
    //update options dialog
    void UpdateOptionsDlgUI();

    // About dialog related operation
    void AttachAboutDlg(AboutDialog* pAboutDlg);
    //dettach about dialog
    void DettachAboutDlg();
    //get about dialog
    AboutDialog* GetAboutDlgInstance();

    // Device disable dialog related operation
//    void AttachDeviceDisableDlg(DeviceDisableDialog* pDeviceDlg);
//    void DettachDeviceDisableDlg();
//    DeviceDisableDialog* GetDeviceDisableDlgInstance();

private:
    //constructor
    DataMiddle();
    static DataMiddle* m_pDataMiddle;

    PMDialog* m_pPMDialog;
    PMEditDialog* m_pPMEditDlg;
    OptionsDialog* m_pOptionsDlg;
    AboutDialog *m_pAboutDialog;
//    DeviceDisableDialog* m_pDeviceDlg;
};

#endif
