/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMNew3Dialog.cpp

Description:

    This file implements class PMNew3Dialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMNew3Dialog.h"
#include "include/PMGlobalConstant.h"
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>

//(*InternalHeaders(PMNew3Dialog)
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

//(*IdInit(PMNew3Dialog)
const long PMNew3Dialog::ID_STATICBITMAP_NEW3TOP = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_LCDBRIGHTNESS = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_LANSPEED = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_cLOSEDLCD = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_SYSSTANDBY = wxNewId();
const long PMNew3Dialog::ID_COMBOBOX_LCDBRIGHTNESS = wxNewId();
const long PMNew3Dialog::ID_COMBOBOX_LANSPEED = wxNewId();
const long PMNew3Dialog::ID_COMBOBOX_CLOSELCD = wxNewId();
const long PMNew3Dialog::ID_COMBOBOX_SYSSTANDBY = wxNewId();
const long PMNew3Dialog::ID_STATICBOX1 = wxNewId();
const long PMNew3Dialog::ID_GAUGE_PERFORMANCE = wxNewId();
const long PMNew3Dialog::ID_GAUGE_LCDBRIGHTNESS = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_PERFORMANCE = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_LCDBRIGHTNESS2 = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_UI_BATTERYLIFE = wxNewId();
const long PMNew3Dialog::ID_STATICTEXT_BATTERYLIFE = wxNewId();
const long PMNew3Dialog::ID_CHECKBOX_LANSTATUS = wxNewId();
const long PMNew3Dialog::ID_CHECKBOX_WLANSTATUS = wxNewId();
//*)

/**constructor*/
PMNew3Dialog::PMNew3Dialog(wxWizard* wizard) : wxWizardPageSimple(wizard)
{
    //(*Initialize(PMNew3Dialog)
    //*)
	StaticBitmap_New3Top = new wxStaticBitmap(this, ID_STATICBITMAP_NEW3TOP, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Wizard_Banner_3.png")).Rescale(wxSize(500,53).GetWidth(),wxSize(500,53).GetHeight())), wxPoint(0,0), wxSize(500,53), 0, _T("ID_STATICBITMAP_NEW3TOP"));

    StaticTextBaner = new wxStaticText(this, wxID_ANY, _("AC Settings"), wxPoint(13,4), wxDefaultSize, 0, _T("ID_STATICTEXT_BANNER"));
    StaticTextBaner->SetForegroundColour(wxColour(158,206,255));

    StaticTextBaner2 = new wxStaticText(this, wxID_ANY, _("Configure the power settings for AC mode."), wxPoint(13,22), wxDefaultSize, 0, _T("ID_STATICTEXT_Banner2"));
    StaticTextBaner2->SetForegroundColour(wxColour(250,250,250));
    StaticTextBaner2->Wrap(390);

	StaticText_UI_LCDBrightness = new wxStaticText(this, ID_STATICTEXT_UI_LCDBRIGHTNESS, _("Display Brightness:"), wxPoint(10,75), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LCDBRIGHTNESS"));
	StaticText_UI_LCDBrightness->Wrap(150);
	StaticText_UI_LANSpeed = new wxStaticText(this, ID_STATICTEXT_UI_LANSPEED, _("LAN Speed:"), wxPoint(10,120), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LANSPEED"));
	StaticText_UI_LANSpeed->Wrap(150);
	StaticText_UI_CloseLCD = new wxStaticText(this, ID_STATICTEXT_UI_cLOSEDLCD, _("Turn off Display:"), wxPoint(10,165), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_CLOSELCD"));
	StaticText_UI_CloseLCD->Wrap(150);
	StaticText_UI_SysStandby = new wxStaticText(this, ID_STATICTEXT_UI_SYSSTANDBY, _("Enter System Standby:"), wxPoint(10,210), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_SYSSTANDBY"));
	StaticText_UI_SysStandby->Wrap(150);

	ComboBox_LCDBrightness = new wxComboBox(this, ID_COMBOBOX_LCDBRIGHTNESS, wxEmptyString, wxPoint(165,70), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_LCDBRIGHTNESS"));
	ComboBox_LANSpeed = new wxComboBox(this, ID_COMBOBOX_LANSPEED, wxEmptyString, wxPoint(165,115), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_LANSPEED"));
	ComboBox_CloseLCD = new wxComboBox(this, ID_COMBOBOX_CLOSELCD, wxEmptyString, wxPoint(165,160), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_CLOSEDLCD"));
	ComboBox_SysStandby = new wxComboBox(this, ID_COMBOBOX_SYSSTANDBY, wxEmptyString, wxPoint(165,205), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_SYSSTANDBY"));

	CheckBox_WLANStatus = new wxCheckBox(this, ID_CHECKBOX_WLANSTATUS, _("Disable WiFi"), wxPoint(10,250), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_WLANSTATUS"));
	CheckBox_WLANStatus->SetValue(false);
	CheckBox_LANStatus = new wxCheckBox(this, ID_CHECKBOX_LANSTATUS, _("Disable LAN"), wxPoint(10,280), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_LANSTATUS"));
	CheckBox_LANStatus->SetValue(false);

    StaticBox1 = new wxStaticBox(this, ID_STATICBOX1, wxEmptyString, wxPoint(325,60), wxSize(170,215), 0, _T("ID_STATICBOX1"));

	StaticText_UI_EffectiveofSettings = new wxStaticText(this, ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS, _("Effective of Settings"), wxPoint(335,75), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS"));
    StaticText_UI_EffectiveofSettings->Wrap(130);
    StaticText_UI_Performance = new wxStaticText(this, ID_STATICTEXT_UI_PERFORMANCE, _("Performance"), wxPoint(335,105), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_PERFORMANCE"));
	StaticText_UI_Performance->Wrap(130);
	StaticText_UI_LCDBrightness2 = new wxStaticText(this, ID_STATICTEXT_UI_LCDBRIGHTNESS2, _("Display Brightness"), wxPoint(335,159), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LCDBRIGHTNESS2"));
	StaticText_UI_LCDBrightness2->Wrap(130);
	StaticText_UI_BatteryLife = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYLIFE, _("Battery Life"), wxPoint(335,213), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYLIFE"));
	StaticText_UI_BatteryLife->Wrap(130);

	Gauge_Performance = new wxGauge(this, ID_GAUGE_PERFORMANCE, 100, wxPoint(335,134), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_PERFORMANCE"));
	Gauge_LCDBrightness = new wxGauge(this, ID_GAUGE_LCDBRIGHTNESS, 100, wxPoint(335,188), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_LCDBrightness"));
	StaticText_BatteryLife = new wxStaticText(this, ID_STATICTEXT_BATTERYLIFE, _("Not Applicable"), wxPoint(335,242), wxDefaultSize, 0, _T("ID_STATICTEXT_BATTERYLIFE"));
    StaticText_BatteryLife->Wrap(130);

    // Set font
    StaticTextBaner->SetFont(wxFont(11,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT));

    wxFont StaticTextFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    StaticTextBaner2->SetFont(StaticTextFont);
    StaticText_UI_LCDBrightness->SetFont(StaticTextFont);
    StaticText_UI_LANSpeed->SetFont(StaticTextFont);
    StaticText_UI_CloseLCD->SetFont(StaticTextFont);
    StaticText_UI_SysStandby->SetFont(StaticTextFont);
    ComboBox_LCDBrightness->SetFont(StaticTextFont);
    ComboBox_LANSpeed->SetFont(StaticTextFont);
    ComboBox_CloseLCD->SetFont(StaticTextFont);
    ComboBox_SysStandby->SetFont(StaticTextFont);
    CheckBox_LANStatus->SetFont(StaticTextFont);
    CheckBox_WLANStatus->SetFont(StaticTextFont);

    StaticText_UI_Performance->SetFont(StaticTextFont);
    StaticText_UI_BatteryLife->SetFont(StaticTextFont);
    StaticText_UI_LCDBrightness2->SetFont(StaticTextFont);
    StaticText_BatteryLife->SetFont(StaticTextFont);

    wxFont StaticTextBoldFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	StaticText_UI_EffectiveofSettings->SetFont(StaticTextBoldFont);
	StaticText_UI_EffectiveofSettings->SetForegroundColour(wxColour(20,80,190));

    Gauge_Performance->SetRange(100);
    Gauge_LCDBrightness->SetRange(100);

    // Registe event
    Connect(ID_COMBOBOX_LCDBRIGHTNESS,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMNew3Dialog::OnComboBox_Select);
    Connect(ID_COMBOBOX_LANSPEED,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMNew3Dialog::OnComboBox_Select);

    m_iSchemeId = 0;
    SetComboboxValue();
    Init();

}

/**destructor*/
PMNew3Dialog::~PMNew3Dialog()
{

}

/**initial the comboBox's value*/
void PMNew3Dialog::SetComboboxValue(void)
{
    SETTING_ITEM_MAPPING schemeItemsMap;
    PowerSchemeMgmtProxy::GetInstance()->GetSettingItems(schemeItemsMap);

    //LCD Brightness
    vLCDBrightnessItems = schemeItemsMap[LCD_BRIGHTNESS];
    for (vector<string>::size_type ix = 0; ix != vLCDBrightnessItems.size(); ++ix)
    {
        ComboBox_LCDBrightness->Append(PMUtility::StringToWxString(vLCDBrightnessItems[ix].Description));
    }

    //LAN Speed
    vLANSpeedItems = schemeItemsMap[LAN_SPEED];
    for (vector<string>::size_type ix = 0; ix != vLANSpeedItems.size(); ++ix)
    {
        ComboBox_LANSpeed->Append(PMUtility::StringToWxString(vLANSpeedItems[ix].Description));
    }

    //TurnOffDisplay
    vCloseLCDItems = schemeItemsMap[CLOSE_LCD];
    for (vector<string>::size_type ix = 0; ix != vCloseLCDItems.size(); ++ix)
    {
        ComboBox_CloseLCD->Append(PMUtility::StringToWxString(vCloseLCDItems[ix].Description));
    }

    //EnterSYSStandby
    vStandbyItems = schemeItemsMap[STANDBY];
    for (vector<string>::size_type ix = 0; ix != vStandbyItems.size(); ++ix)
    {
        ComboBox_SysStandby->Append(PMUtility::StringToWxString(vStandbyItems[ix].Description));
    }
}

/**intial the dialog*/
void PMNew3Dialog::Init()
{
    PScheme_Settings acSettings = new Scheme_Settings;

    PowerSchemeMgmtProxy::GetInstance()->ResetDefaultScheme(807111933, 1, acSettings);

    if (NULL == acSettings)
    {
        return;
    }

    int index = 0;
    map<string, int> valueMap;

    //Set settings Value
    index = acSettings->LCDBrightness;
    ComboBox_LCDBrightness->SetSelection(index);
    valueMap.insert(make_pair(LCD_BRIGHTNESS, index));

    index = acSettings->LANSpeed;
    ComboBox_LANSpeed->SetSelection(index);
    valueMap.insert(make_pair(LAN_SPEED, index));

    index = acSettings->CloseLCD;
    ComboBox_CloseLCD->SetSelection(index);

    index = acSettings->Standby;
    ComboBox_SysStandby->SetSelection(index);

    index = acSettings->LANStatus;
    CheckBox_LANStatus->SetValue(!index);

    index = acSettings->WLANStatus;
    CheckBox_WLANStatus->SetValue(!index);

    UpdateEffectiveness(valueMap);

    if (NULL != acSettings)
    {
        acSettings = NULL;
    }
}

/**update the effectiveness*/
int PMNew3Dialog::UpdateEffectiveness(map<string, int>& valueMap)
{
    int percent = 0;

    PowerSchemeMgmtProxy::GetInstance()->CalculatePerformance(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_Performance->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateDisplayBrightness(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_LCDBrightness->SetValue(percent);

    return 1;
}

/**the comboBox select event handler*/
void PMNew3Dialog::OnComboBox_Select(wxCommandEvent& event)
{
    map<string, int> valueMap;
    int value = ComboBox_LCDBrightness->GetCurrentSelection();
    valueMap.insert(make_pair(LCD_BRIGHTNESS, value));

    value = ComboBox_LANSpeed->GetCurrentSelection();
    valueMap.insert(make_pair(LAN_SPEED, value));

    UpdateEffectiveness(valueMap);

}
