/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "TaskBarBalloon.h"
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "CustomStaticText.h"
#if defined(__WXMSW__)
#include <windows.h>
#endif

#include "ENMUtil.h"

const int miniLap = 15;

BEGIN_EVENT_TABLE(TaskBarBalloon, wxBitmapDialog)
END_EVENT_TABLE()

#if defined(__UNIX__)
TaskBarBalloon::TaskBarBalloon(wxWindow* dlg, const wxString& title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strImagePath + _T("balloon.png"), wxBITMAP_TYPE_PNG), dlg, wxID_ANY, wxEmptyString)
{
    int width = GetSize().GetWidth();
    int height = GetSize().GetHeight();
    int margin = 15, b = 12;
    wxSize labelSize((width - 10) / 2 - margin, 15);

    int x = margin, y = margin;
    m_SuccTip = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(x, y), wxSize(width - margin * 2, 20));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);

	y = 45;
	m_StatusTip = new wxStaticText(this, wxID_ANY, _("Name:"), wxPoint(margin, y), labelSize);
	m_Status = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(width / 2, y), labelSize, wxST_NO_AUTORESIZE);

	y += labelSize.GetHeight() + b;
	m_TypeTip = new wxStaticText(this, wxID_ANY, _("Type:"), wxPoint(margin, y), labelSize);
	m_Type = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(width / 2, y), labelSize);

	y += labelSize.GetHeight() + b;
	m_SpeedTip = new wxStaticText(this, wxID_ANY, _("Speed:"), wxPoint(margin, y), labelSize);
	m_Speed = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(width / 2, y), labelSize);

	y += labelSize.GetHeight() + b;
	m_SignalQualityTip = new wxStaticText(this, wxID_ANY, _("Signal Quality:"), wxPoint(margin, y), labelSize);
	wxBitmap sqBmp(::wxGetApp().strImagePath + _T("signal-0.png"), wxBITMAP_TYPE_PNG);
	m_bmpSignalQuality = new wxStaticBitmap(this, wxID_ANY, sqBmp, wxPoint(width / 2, y - 6));
	m_SignalQuality = new wxStaticText(this, wxID_ANY, _T(""), wxPoint(width / 2 + sqBmp.GetWidth() + b, y), labelSize);

    wxRect clientRect = ::wxGetClientDisplayRect();
    wxSize dialogSize = this->GetSize();
    wxPoint finalPos(clientRect.width - dialogSize.GetWidth() - miniLap + clientRect.x, miniLap + clientRect.y);
    this->Move(finalPos);
}
#endif

#if defined(__WXMSW__)
TaskBarBalloon::TaskBarBalloon(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strImagePath + _T("balloon.png"),wxBITMAP_TYPE_PNG), dlg, wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(29,18), wxSize(240,25), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, wxID_ANY, _("Type:"), wxPoint(30,72), wxSize(115,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(150,72), wxSize(128,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_SpeedTip = new CustomStaticText(this, wxID_ANY, _("Speed:"), wxPoint(30,96), wxSize(115,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Speed = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(150,96), wxSize(128,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, wxID_ANY, _("Name:"), wxPoint(30,48), wxSize(115,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(150,48), wxSize(128,14), 0, _T("ID_STATICTEXT_STATUS"));
	m_SignalQualityTip = new CustomStaticText(this, wxID_ANY, _("Signal Quality:"), wxPoint(30,125), wxSize(115,14), 0, _T("ID_STATICTEXT_SIGNALQUALITYTIP"));
	m_bmpSignalQuality = new wxStaticBitmap(this, wxID_ANY, wxBitmap(wxImage(::wxGetApp().strImagePath + _T("empty.png"))), wxPoint(150,120), wxDefaultSize, 0, _T("ID_STATICBITMAP_SIGNALQUALITY"));
	m_SignalQuality = new CustomStaticText(this, wxID_ANY, _T(""), wxPoint(210,125), wxDefaultSize, 0, _T("ID_STATICTEXT_SIGNALQUALITY"));

    wxRect clientRect = ::wxGetClientDisplayRect();
    wxSize dialogSize = this->GetSize();
    wxPoint finalPos(clientRect.width - dialogSize.GetWidth() - miniLap + clientRect.x, clientRect.height - dialogSize.GetHeight() - miniLap + clientRect.y);
    this->Move(finalPos);

    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
}
#endif

TaskBarBalloon::~TaskBarBalloon()
{
}

void TaskBarBalloon::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);

    int iWidth = 0, iHeight = 0;
    this->GetClientSize( &iWidth, &iHeight );

    wxPen pen(this->GetForegroundColour());
    dc.SetPen(pen);

    wxBrush brush(this->GetBackgroundColour());
    dc.SetBrush(brush);

    dc.Clear();
    dc.DrawRectangle(0,0,iWidth,iHeight);
}

void TaskBarBalloon::OnClick(wxMouseEvent&)
{
}

void TaskBarBalloon::SetConnectionTip(const wxString& strTip)
{
    m_SuccTip->SetLabel(strTip);
}

void TaskBarBalloon::SetConnectionType(const wxString& strType)
{
    m_Type->SetLabel(strType);
}

void TaskBarBalloon::SetConnectionSpeed(const wxString& strSpeed)
{
    m_Speed->SetLabel(strSpeed);
}

void TaskBarBalloon::SetConnectionStatus(const wxString& strStatus)
{
    wxString status = strStatus;
    if ( strStatus.Length() > 20 )
    {
        status = strStatus.Left(20) + _("...");
    }
    status.Replace(_T("&"), _T("&&"));
    m_Status->SetLabel(status);
}

void TaskBarBalloon::SetSignalQuality(int iSignalQuality)
{
    m_SignalQuality->SetLabel(wxString::Format(_T("%d"), iSignalQuality) + _T("%"));
}

void TaskBarBalloon::SetSignalQualityBmp(int iSignalQuality)
{
    if ( iSignalQuality < 0 )
    {
        iSignalQuality = (-iSignalQuality) % 100;
    }

    if ( 0 == iSignalQuality )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-0.png"))));
    }
    else if ( (0 < iSignalQuality) && (iSignalQuality <= 20) )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-20.png"))));
    }
    else if ( (20 < iSignalQuality) && (iSignalQuality <= 40) )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-40.png"))));
    }
    else if ( (40 < iSignalQuality) && (iSignalQuality <= 60) )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-60.png"))));
    }
    else if ( (60 < iSignalQuality) && (iSignalQuality <= 80) )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-80.png"))));
    }
    else if ( (80 < iSignalQuality) && (iSignalQuality <= 100) )
    {
        m_bmpSignalQuality->SetBitmap(wxBitmap(wxImage(::wxGetApp().strImagePath + _T("signal-100.png"))));
    }
}

